package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.security.cert.*; // Dla klasy X509Certificate

/** Serwlet wywietla dane na temat wywoa SSL. Wywoania,
 *  ktre nie s wywoaniami SSL, s przekierowywane do SSL.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class SecurityInfo extends HttpServlet {
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    // Przekierowanie zwykych wywoa do
    // odpowiadajacych im wywoa SSL.
    if (request.getScheme().equalsIgnoreCase("http")) {
      String origURL = request.getRequestURL().toString();
      String newURL = httpsURL(origURL);
      String formData = request.getQueryString();
      if (formData != null) {
        newURL = newURL + "?" + formData;
      }
      response.sendRedirect(newURL);
    } else {
      String currentURL = request.getRequestURL().toString();
      String formData = request.getQueryString();
  
      PrintWriter out = response.getWriter();
      String docType =
        "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
        "Transitional//EN\">\n";
      String title = "Informacje o zabezpieczeniach";
      out.println
        (docType +
         "<HTML>\n" +
         "<HEAD><TITLE>" + title +
         "</TITLE></HEAD>\n" +
         "<BODY BGCOLOR=\"#FDF5E6\">\n" +
         "<H1>" + title + "</H1>\n" +
         "<UL>\n" +
         "  <LI>Adres URL: " + currentURL + "\n" +
         "  <LI>Dane: " + formData);
      boolean isSecure = request.isSecure();
      if (isSecure) {
        String keyAttribute =
          "javax.servlet.request.key_size";
        // Dostpne tylko w specyfikacji serwletw w wersji 2.3
        Integer keySize =
          (Integer)request.getAttribute(keyAttribute);
        String sizeString =
          replaceNull(keySize, "Unknown");
        String cipherAttribute =
          "javax.servlet.request.cipher_suite";
        // Dostpne tylko w specyfikacji serwletw w wersji 2.3
        String cipherSuite =
          (String)request.getAttribute(cipherAttribute);
        String cipherString =
          replaceNull(cipherSuite, "Unknown");
        String certAttribute =
          "javax.servlet.request.X509Certificate";
        // Dostpne tylko w specyfikacji serwletw w wersji 2.2 i 2.3
        X509Certificate certificate =
          (X509Certificate)request.getAttribute(certAttribute);
        String certificateString =
          replaceNull(certificate, "None");
        out.println
          ("  <LI>SSL: true\n" +
           "  <UL>\n" +
           "    <LI>Rozmiar klucza: " + sizeString + "\n" +
           "    <LI>Algorytm szyfrowania: " + cipherString + "\n" +
           "    <LI>Certyfikat klienta: " +
           certificateString + "\n" +
           "  </UL>");
      }
      out.println
        ("</UL>\n" +
         "</BODY></HTML>");
    }
  }

  // Przeksztaca URL http://cotam na https://cotam.
  
  private String httpsURL(String origURL) {
    int index = origURL.indexOf(":");
    StringBuffer newURL = new StringBuffer(origURL);
    newURL.insert(index, 's');
    return(newURL.toString());
  }

  // Jeeli pierwszym argumentem jest null, zwraca drugi argument.
  // W przeciwnym razie pierwszy argument jest rzutowany do typu String,
  // a uzyskany cig znakw zostaje zwrcony.

  private String replaceNull(Object obj, String fallback) {
    if (obj == null) {
      return(fallback);
    } else {
      return(obj.toString());
    }
  }
}

